# **ChatGPT・Geminiで学ぶComputer Useプログラミング入門** 

##  ～ Pythonで体験する「AIによるPC制御」 ～


## 全体の構成案

---

### 第1章　AIが“PCを動かす”時代が来た！

AIによるPC操作とはどういうものか、簡単に説明する。全体の導入部。具体的な操作はまだしない。

* ChatGPT・Gemini・Claudeの最新動向  
* 「Computer Use」とは何か？  
* コード生成AI → アプリ制御AIへの進化  
* これからのプログラマー像：「AIに操作を任せる設計者」

---

### 第2章　ChatGPT Apps insideを利用する

まずはChatGPTのApps insideから。機能の説明、利用のための手順などを説明し、実際にどのようなことができるか試すところまで行う。

* ChatGPTの進化と「Computer Use」機能の登場  
* Apps insideとは：ChatGPTがPCアプリやWebを直接操作できる仕組み  
* できることとできないこと  
  * ファイル操作  
  * Webアプリ操作  
  * 外部ツール連携（Google Drive、Canva、Slackなど）  
* 競合技術比較：Gemini 2.5「Computer Use」、Claude 3.5「Artifacts」との違い  
* Apps insideの基本操作  
  * ChatGPTアプリ内の「Apps」タブの見方  
  * 初期設定：権限付与と接続  
* Appsの種類と事例  
  * File Browser  
    Code Interpreter  
  * Canvas  
  * Web Browser

---

### 第3章　Apps insideコーディング

プログラム内からApps insideを使ってPCを操作する技術を学ぶ。基本はPython。プロンプトをAPIに送信し操作を行うまでの流れを説明し、実際に簡単なプログラムを作成する。

* ChatGPTが実際にPCを操作する仕組み（Apps insideの技術的背景）  
* 実行の流れ：ユーザー指示 → アプリ起動 → 実際のクリック・入力  
* 例：ChatGPTに「Wordで書類を開いて要約を追記して保存させる」  
* 自動操作の安全対策（許可制・プライバシー・制限）  
* 実際の画面操作デモ（スクリーンショット解説）  
* Apps inside × Python：コードで制御する  
* PythonスクリプトからApps機能を呼び出す（例：OpenAI API経由）  
* Pythonコードによる自動化例：  
  * ファイルの読み書きとAI要約  
  * Webデータ収集＋レポート生成  
  * ローカル画像解析とレポート作成  
* Gradio＋Apps inside連携によるGUI化  
   → ChatGPT内で実行できるアプリを自作

---

### 第4章　実践プロジェクト

実践的に利用できるプロジェクトを作成することでApps inside利用の応用力を身につける。とりあえず２つの例を考えたが、作成するアプリの内容は更に変更可能。

AI秘書を作る

* 概要：スケジュール管理、メール整理、ファイル検索を自動化  
* 実装ステップ：  
  * ChatGPTにメールの要約をさせる  
  * Pythonでスケジュールファイル操作  
  * Apps insideで自動保存・報告  
* 動作シナリオ例：「今日の予定を確認し、関連資料を開くAI秘書」

自動レポート作成システム

* ChatGPTが自動で週報・レポートを作成  
* データ分析（Excel／CSV）→ テンプレート化 → Word出力  
* PythonでApps insideを利用した一連の処理を自動化  
* ChatGPT＋Python連携の「業務自動化」モデル構築

Claude Desktopを利用したComputer Useの利用

---

### 第5章　Gemini Computer Useを利用する

もう１つのPC操作機能、GeminiのComputer Useについて。基本的な使い方を説明し、実際に使ってみてPCを操作できるようにする。

* Geminiの進化とComputer Use機能  
* ChatGPTとの違い  
  Apps inside vs Gemini Computer Use  
* Geminiでできること：  
  * ファイル操作  
  * Web操作  
  * アプリ自動操作  
  * Pythonコード実行との連携  
* Gemini Computer Useの基本操作  
* Geminiのアカウント作成とAPIキー管理

* PC操作自動化の基礎  
* GeminiがPC操作を行う仕組み  
  * Command生成 → Python実行 → OS操作  
* 代表的な操作：  
  * ファイル開閉・保存  
  * Webブラウザ操作  
    データコピー＆貼り付け  
* GradioによるUI作成

---

### 第6章　PythonからComputer Useを操作する

プログラム内からComputer Useを利用する。基本的な処理の流れを理解し、実際に簡単なプログラムを作成してAIでPCを操作してみる。

* PythonコードでGeminiを利用する流れ  
* Pythonからの接続方法  
* google.generativeaiライブラリの導入  
* 基本コマンド：  
  * ファイル読み書き  
  * Web情報取得  
  * アプリ操作（Excel, Word, PDF）  
* ファイル自動操作例：  
  * PDF要約  
  * Excel分析  
  * Word文書作成  
* Web情報取得＋レポート自動生成  
  PythonとGeminiでGUI連携（Gradioなど）

---

### 第7章　実践プロジェクト

Computer Userで、実践的なプロジェクトの作成を行う。これも実際に使えるサンプルを考え、差し替えてもよい。ChatGPTと同じものを作るか、全く違うものにするか要検討。

AI秘書の作成

* Geminiでスケジュール管理とメール整理  
* Pythonスクリプトから指示を送り、自動実行  
* シナリオ：  
  「今日の予定を確認、関連ファイルを開き、要約を生成」  
* チェックリスト付き操作手順

自動レポート作成システム

* Gemini＋Pythonで週次レポート自動生成  
  データ収集 → 分析 → Word/Excel生成 → 保存  
* スクリプト例：  
  CSV解析 → 集計 → グラフ作成 → PowerPoint自動生成

---

以上。
